<?php
session_start();
include "include/config.php"; // mysqli $con ready

$message = "";

if (isset($_POST['submit'])) {
    $code = trim($_POST['code']);
    $role_name = trim($_POST['role_name']);
    $status = $_POST['status'];
    $created_by = $_SESSION['id'] ?? 0; // logged in user id
    $modified_by = $created_by;
    $modified_on = date("Y-m-d H:i:s");

    // check duplicate code
    $check = $con->prepare("SELECT id FROM role_master WHERE code=?");
    $check->bind_param("s", $code);
    $check->execute();
    $check->store_result();
    if ($check->num_rows > 0) {
        $message = "Role code already exists!";
    } else {
        $stmt = $con->prepare("INSERT INTO role_master (code, role_name, status, created_by, modified_by, modified_on) VALUES (?,?,?,?,?,?)");
        $stmt->bind_param("ssissi", $code, $role_name, $status, $created_by, $modified_by, $modified_on);

        if ($stmt->execute()) {
            $message = "Role added successfully!";
        } else {
            $message = "Error: " . $stmt->error;
        }
        $stmt->close();
    }
    $check->close();
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Manage roles</title>
    <link href="http://fonts.googleapis.com/css?family=Lato:300,400,400italic,600,700|Raleway:300,400,500,600,700|Crete+Round:400italic" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.min.css">
    <link rel="stylesheet" href="vendor/themify-icons/themify-icons.min.css">
    <link href="vendor/animate.css/animate.min.css" rel="stylesheet" media="screen">
    <link href="vendor/perfect-scrollbar/perfect-scrollbar.min.css" rel="stylesheet" media="screen">
    <link href="vendor/switchery/switchery.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" media="screen">
    <link href="vendor/select2/select2.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-datepicker/bootstrap-datepicker3.standalone.min.css" rel="stylesheet" media="screen">
    <link href="vendor/bootstrap-timepicker/bootstrap-timepicker.min.css" rel="stylesheet" media="screen">
    <link rel="stylesheet" href="assets/css/styles.css">
    <link rel="stylesheet" href="assets/css/plugins.css">
    <link rel="stylesheet" href="assets/css/themes/theme-1.css" id="skin_color" />
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<body>
    <div id="app">
        <?php include('include/sidebar.php'); ?>
        <div class="app-content">
            <?php include('include/header.php'); ?>
            <div class="main-content">
                <div class="wrap-content container" id="container">
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h4 class="mb-0">Add New Role</h4>
                        </div>
                        <div class="card-body">
                            <?php if ($message): ?>
                                <div class="alert <?= strpos($message, 'Error') !== false ? 'alert-danger' : 'alert-success' ?> alert-dismissible fade show" role="alert">
                                    <?= $message ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                                </div>
                            <?php endif; ?>
                            <form method="post">
                                <div class="mb-3">
                                    <label class="form-label">Role Code *</label>
                                    <input type="text" name="code" class="form-control" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Role Name *</label>
                                    <input type="text" name="role_name" class="form-control" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Status</label>
                                    <select name="status" class="form-select">
                                        <option value="1">Active</option>
                                        <option value="0">Inactive</option>
                                    </select>
                                </div>
                                <button type="submit" name="submit" class="btn btn-primary w-100">Add Role</button>
                            </form>
                        </div>
                    </div>

                    <!-- Optional: Role List Table -->
                    <div class="card shadow mt-4">
                        <div class="card-header bg-secondary text-white">
                            <h5 class="mb-0">Existing Roles</h5>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Code</th>
                                        <th>Role Name</th>
                                        <th>Status</th>
                                        <th>Created By</th>
                                        <th>Modified On</th>
                                        <th>Actions</th> <!-- New Column -->
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $res = $con->query("SELECT * FROM role_master ORDER BY id DESC");
                                    $i = 1;
                                    while ($row = $res->fetch_assoc()):
                                    ?>
                                        <tr>
                                            <td><?= $i++ ?></td>
                                            <td><?= htmlspecialchars($row['code']) ?></td>
                                            <td><?= htmlspecialchars($row['role_name']) ?></td>
                                            <td><?= $row['status'] == 1 ? 'Active' : 'Inactive' ?></td>
                                            <td><?= $row['created_by'] ?></td>
                                            <td><?= $row['modified_on'] ?></td>
                                            <td>
                                                <a href="edit_role.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                                                <a href="delete_role.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure to delete this role?');">Delete</a>
                                            </td>
                                        </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>


                </div>

                <?php include('include/footer.php'); ?>
                <?php include('include/setting.php'); ?>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Scripts -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <!-- Scripts -->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.min.js"></script>
    <script src="vendor/modernizr/modernizr.js"></script>
    <script src="vendor/jquery-cookie/jquery.cookie.js"></script>
    <script src="vendor/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="vendor/switchery/switchery.min.js"></script>
    <script src="vendor/maskedinput/jquery.maskedinput.min.js"></script>
    <script src="vendor/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
    <script src="vendor/autosize/autosize.min.js"></script>
    <script src="vendor/selectFx/classie.js"></script>
    <script src="vendor/selectFx/selectFx.js"></script>
    <script src="vendor/select2/select2.min.js"></script>
    <script src="vendor/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
    <script src="vendor/bootstrap-timepicker/bootstrap-timepicker.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/form-elements.js"></script>
    <script>
        jQuery(document).ready(function() {
            Main.init();
            FormElements.init();
        });
    </script>
    <script>
        // Initialize Select2 on the patient dropdown
        $(document).ready(function() {
            $('#patientSelect').select2({
                placeholder: "Search Patient Name",
                allowClear: true
            });
        });
    </script>

</body>

</html>